# finaquant Financial Analytics - www.finaquant.com
# Copyright: Tunc Ali Ktkcoglu 2012, version: 24April2012
# TITLE: Share Class Fee Analyzer
# Related web page:
# http://finaquant.com/fee-calculator-and-analyzer-for-share-classes-of-mutual-funds-1-calculation/991
#
# Compare total returns of different share classes of a mutual fund
# Share classes:
# A: Front-end load with volume discounts, low annual distribution fee
# B: Back-end load (CDSC), medium-high distribution fee
# C: Low back-end load (CDSC), high distribution fee

#**************************************************************************
# Share class specific input parameters
#**************************************************************************
# I try to define parameters in an ordered way here (list of lists) to
# avoid a mess of parameter names

# Parameters common for all share classes A, B and C
print('Set common input parameters for all share classes')
AnnualManagementFeeRates = matrix(c(   	# fee rates in BP (basis points, 1 BP = 0.01% = 1/100000)
    80,          50000,         		# fee rate = 80 BP for 0 <= Amount < 500000
    70,          100000,        		# fee rate = 70 BP for 500000 <= Amount < 1000000
    60,          999999999),    		# fee rate = 60 BP for Amount >= 1000000
	ncol=2, byrow=TRUE)
MngFeeScaleLogic = 'class'
OtherAnnualServiceFeeRates = c(10, 0) 	# 10 BP + $0 per share, annually 
OtherSubscriptionFeeRates = c(0, 0)   	# 0% + $0 per share, at subscription
OtherRedemptionFeeRates = c(0, 0)      	# 0% + $0 per share, at redemption

# Share class specific parameters
print('Set share class specific input parameters')
# Share class A
FrondEndLoadRates = matrix(c(		# percentage and exclusive upper limit
    5.00,        50000,      		# fee rate = 5.00% for 0 <= Amount < 50000
    4.50,        100000,     		# fee rate = 4.50% for 50000 <= Amount < 100000
    3.70,        250000,
    2.80,        500000,
    2.00,        999999999),  		# fee rate = 2% for Amount >= 500000
	ncol=2, byrow=TRUE)
DistrFeeRate = 0.2
BackEndLoadCDSC = c(0)
ParameterListA = list(FrondEndLoadRates, BackEndLoadCDSC, DistrFeeRate, 
	AnnualManagementFeeRates, MngFeeScaleLogic, OtherAnnualServiceFeeRates,
	OtherSubscriptionFeeRates, OtherRedemptionFeeRates)

# Share class B
FrondEndLoadRates = matrix(c(		# percentage and exclusive upper limit
    0.00,        999999999), ncol=2, byrow=TRUE)
DistrFeeRate = 0.8
BackEndLoadCDSC = c(5.0, 4.0, 3.0, 2.0, 1.0)
ParameterListB = list(FrondEndLoadRates, BackEndLoadCDSC, DistrFeeRate,
	AnnualManagementFeeRates, MngFeeScaleLogic, OtherAnnualServiceFeeRates,
	OtherSubscriptionFeeRates, OtherRedemptionFeeRates)
	
# Share class C
FrondEndLoadRates = matrix(c(		# percentage and exclusive upper limit
    0.00,        999999999), ncol=2, byrow=TRUE)
DistrFeeRate = 1.0
BackEndLoadCDSC = c(0)
ParameterListC = list(FrondEndLoadRates, BackEndLoadCDSC, DistrFeeRate,
	AnnualManagementFeeRates, MngFeeScaleLogic, OtherAnnualServiceFeeRates,
	OtherSubscriptionFeeRates, OtherRedemptionFeeRates)

# all parameters in a list of lists	
ParameterList = list(ParameterListA, ParameterListB, ParameterListC)

# load functions
source('FeeCalculator_functions.r')

#**************************************************************************
# Simulation of fee calculation with variable parameters
#**************************************************************************
print('Simulation of fee calculation with variable parameters');
# Varied parameters:
# Share classes
# NumberOfShares
# N: Total number of calculation periods
# AssumedFixedReturn: Assumed fixed fund return for all calculation periods

# Simulation parameters
ShareSamples = 10
Nmax = 10
MaxReturn = 10
SharePrice = 500
MaxShareInd = 10
ShareMultiplier = 100  # i.e.  #shares = 100, 200, ..., 1000

# call simultion function
res = SimulateTotalReturns(
    ParameterList,    
    Nmax,           
    MaxReturn,          
    SharePrice,         
    MaxShareInd,        
    ShareMultiplier)
TotalFundReturn = res[[1]]
FinalAssetValue = res[[2]]

#**************************************************************************
# Analyze results to compare total returns of share classes
#**************************************************************************
# assumed fixed fund return for all 3 cases below
AssumedFixedReturn = 5

# CASE 1
print('Case 1: Assumed annual return = 5%, #shares = 100, N is varied')
NumberOfShares = 100
IndShares = NumberOfShares / ShareMultiplier
# initiate vectors
TotalReturnsA = c()
TotalReturnsB = c()
TotalReturnsC = c()

for (i in 1:Nmax){
    TotalReturnsA[i] = TotalFundReturn[1,IndShares,i,AssumedFixedReturn]
    TotalReturnsB[i] = TotalFundReturn[2,IndShares,i,AssumedFixedReturn]
    TotalReturnsC[i] = TotalFundReturn[3,IndShares,i,AssumedFixedReturn]
}
x = 1:Nmax
plot(x,TotalReturnsA,type="l",col="blue",xlab='period N (years)',
	ylab='total return in %',main='r = 5%, #shares = 100 (A blue, B green, C red)') 
lines(x,TotalReturnsB,col="green")
lines(x,TotalReturnsC,col="red")
dev.new() 	# opens a new diagram so that the previous one is not overwritten

# CASE 2
print('Case 2: Assumed annual return = 5%, #shares = 500, N is varied')
NumberOfShares = 500
IndShares = NumberOfShares / ShareMultiplier
# initiate vectors
TotalReturnsA = c()
TotalReturnsB = c()
TotalReturnsC = c()

for (i in 1:Nmax){
    TotalReturnsA[i] = TotalFundReturn[1,IndShares,i,AssumedFixedReturn]
    TotalReturnsB[i] = TotalFundReturn[2,IndShares,i,AssumedFixedReturn]
    TotalReturnsC[i] = TotalFundReturn[3,IndShares,i,AssumedFixedReturn]
}
x = 1:Nmax
plot(x,TotalReturnsA,type="l",col="blue",xlab='period N (years)',
	ylab='total return in %',main='r = 5%, #shares = 500 (A blue, B green, C red)') 
lines(x,TotalReturnsB,col="green")
lines(x,TotalReturnsC,col="red")
dev.new() 	# opens a new diagram so that the previous one is not overwritten
 
# CASE 3
print('Case 3: Assumed annual return = 5%, #shares = 1000, N is varied')
NumberOfShares = 1000
IndShares = NumberOfShares / ShareMultiplier
# initiate vectors
TotalReturnsA = c()
TotalReturnsB = c()
TotalReturnsC = c()

for (i in 1:Nmax){
    TotalReturnsA[i] = TotalFundReturn[1,IndShares,i,AssumedFixedReturn]
    TotalReturnsB[i] = TotalFundReturn[2,IndShares,i,AssumedFixedReturn]
    TotalReturnsC[i] = TotalFundReturn[3,IndShares,i,AssumedFixedReturn]
}
x = 1:Nmax
plot(x,TotalReturnsA,type="l",col="blue",xlab='period N (years)',
	ylab='total return in %',main='r = 5%, #shares = 1000 (A blue, B green, C red)') 
lines(x,TotalReturnsB,col="green")
lines(x,TotalReturnsC,col="red")
dev.new() 	# opens a new diagram so that the previous one is not overwritten

#**************************************************************************
# Surface plot for optimal share class
#**************************************************************************
print('Surface plot for optimal share class: Assumed annual return = 5%')
AssumedFixedReturn = 5

OptimalShareClass = matrix(0,10,10)
for (IndShares in 1:10) {
	for (Period in 1:10) {
	OptimalShareClass[IndShares,Period] = FindOptimalShareClass(TotalFundReturn,IndShares,Period,AssumedFixedReturn)
	}
}

# filled contour plot
# graph can be improved with color maps, axis labels etc.
filled.contour(OptimalShareClass, main="Optimal share class (r = 5%)", nlevels=3)
dev.new()

